﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class WagerRaceConfiguration : ConfigurationElement
{
    public Vector2 DestinationIconRenderSize { get; private set; }
    public float OddsMultiplierRoundFactor { get; private set; }
    public int WagerIncrement { get; private set; }
    public WagerRaceEasyConfiguration Easy { get; private set; }
    public WagerRaceMediumConfiguration Medium { get; private set; }
    public WagerRaceHardConfiguration Hard { get; private set; }

    public WagerRaceConfiguration() : base("WagerRace")
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            DestinationIconRenderSize = configElem.Element("DestinationIconRenderSize").Value.ToVector2();
            OddsMultiplierRoundFactor = Convert.ToSingle(configElem.Element("OddsMultiplierRoundFactor").Value);
            WagerIncrement = Convert.ToInt32(configElem.Element("WagerIncrement").Value);

            //Create our sub-configuration objects
            Easy = new WagerRaceEasyConfiguration();
            Medium = new WagerRaceMediumConfiguration();
            Hard = new WagerRaceHardConfiguration();

            //Let's try to parse all of our sub configurations, passing in the corresponding parent elements
            if (Easy.Parse(configElem.Element("Easy")))
            {
                if (Medium.Parse(configElem.Element("Medium")))
                {
                    if (Hard.Parse(configElem.Element("Hard")))
                    {
                        return true;    //Parsed everything successfully!
                    }

                    else
                    {
                        Debug.LogError("ERROR: Failed to parse wager race hard configuration.");
                    }
                }

                else
                {
                    Debug.LogError("ERROR: Failed to parse wager race medium configuration.");
                }
            }

            else
            {
                Debug.LogError("ERROR: Failed to parse wager easy configuration.");
            }

            return false;   //We must have failed to parse one of the configurations
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing wager race configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
